// Simple script to make the country select searchable (client-side filter)
document.addEventListener('DOMContentLoaded', function(){
  var select = document.querySelector('select[name="country_code"]');
  if(!select) return;
  var input = document.createElement('input');
  input.placeholder = 'Type to filter countries...';
  input.style.display = 'block';
  input.style.marginBottom = '8px';
  select.parentNode.insertBefore(input, select);
  input.addEventListener('input', function(){
    var q = this.value.toLowerCase();
    for(var i=0;i<select.options.length;i++){
      var opt = select.options[i];
      opt.style.display = opt.text.toLowerCase().includes(q) ? 'block' : 'none';
    }
  });
});
